local assets=
{
	Asset("ANIM", "anim/nightmarebrick.zip"),
	Asset("IMAGE", "images/inventoryimages/nightmarebrick.tex"),
	Asset("ATLAS", "images/inventoryimages/nightmarebrick.xml"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("cutstone")
    inst.AnimState:SetBuild("nightmarebrick")
    inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetMultColour(0.6, 0.6, 0.6, 0.6)
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "nightmarebrick"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nightmarebrick.xml"

	inst:AddComponent("repairer")
	inst.components.repairer.repairmaterial = "nightmares"
	inst.components.repairer.healthrepairvalue = 65


	return inst
end

return Prefab( "common/inventory/nightmarebrick", fn, assets) 
